package de.test.sensor;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

public class main extends Activity implements SensorEventListener {
	private SensorManager mSensorManager;
	private Sensor accelerometer;
	private Sensor orientation;
	private Sensor gyroscope;
	private TextView accuracyLabel;
	private TextView labelX, labelY, labelZ;

	float[] mGravity;
	float[] mGeomagnetic;
	float azimut;
	private float[] gravity = new float[3];
	private float[] value = new float[3];
	private long lastUpdate = -1;
	private static final float NS2S = 1.0f / 1000000000.0f;
	private float timestamp;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		accuracyLabel = (TextView) findViewById(R.id.label_accuracy);
		labelX = (TextView) findViewById(R.id.label_x);
		labelY = (TextView) findViewById(R.id.label_y);
		labelZ = (TextView) findViewById(R.id.label_z);

		mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
		// accelerometer = mSensorManager
		// .getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
		// orientation =
		// mSensorManager.getDefaultSensor(Sensor.TYPE_ORIENTATION);
		gyroscope = mSensorManager.getDefaultSensor(Sensor.TYPE_GYROSCOPE);

	}

	@Override
	protected void onPause() {
		super.onPause();
		mSensorManager.unregisterListener(this);
	}

	@Override
	protected void onResume() {
		super.onResume();
		mSensorManager.registerListener(this, accelerometer,
				SensorManager.SENSOR_DELAY_UI);
		mSensorManager.registerListener(this, orientation,
				SensorManager.SENSOR_DELAY_UI);
		mSensorManager.registerListener(this, gyroscope,
				SensorManager.SENSOR_DELAY_UI);
		gravity[0] = 0;
		gravity[1] = 0;
		gravity[2] = 0;
	}

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {
		switch (accuracy) {
		case SensorManager.SENSOR_STATUS_UNRELIABLE:
			accuracyLabel.setText(getString(R.string.accuracy) + ": "
					+ getString(R.string.accuracy_unreliable));
			break;
		case SensorManager.SENSOR_STATUS_ACCURACY_LOW:
			accuracyLabel.setText(getString(R.string.accuracy) + ": "
					+ getString(R.string.accuracy_low));
			break;
		case SensorManager.SENSOR_STATUS_ACCURACY_MEDIUM:
			accuracyLabel.setText(getString(R.string.accuracy) + ": "
					+ getString(R.string.accuracy_medium));
			break;
		case SensorManager.SENSOR_STATUS_ACCURACY_HIGH:
			accuracyLabel.setText(getString(R.string.accuracy) + ": "
					+ getString(R.string.accuracy_high));
			break;
		}
	}

	@Override
	public void onSensorChanged(SensorEvent event) {
		long curTime = System.currentTimeMillis();
		if (lastUpdate == -1 || (curTime - lastUpdate) > 1000) {
			lastUpdate = curTime;

			// http://developer.android.com/reference/android/hardware/SensorEvent.html

			// Acceleration

			// final float alpha = (float) 0.8;
			//
			// gravity[0] = alpha * gravity[0] + (1 - alpha) * event.values[0];
			// gravity[1] = alpha * gravity[1] + (1 - alpha) * event.values[1];
			// gravity[2] = alpha * gravity[2] + (1 - alpha) * event.values[2];
			//
			// value[0] = event.values[0] - gravity[0];
			// value[1] = event.values[1] - gravity[1];
			// value[2] = event.values[2] - gravity[2];
			//
			// labelX.setText(String.format("X: %+2.5f", value[0]));
			// labelY.setText(String.format("Y: %+2.5f", value[1]));
			// labelZ.setText(String.format("Z: %+2.5f", value[2]));

			// Orientation

			// labelX.setText(String.format("X: %+2.5f", event.values[0]));
			// labelY.setText("");
			// labelZ.setText("");

			// Gyroscope

			// if (timestamp != 0) {
			// final float dT = (event.timestamp - timestamp) * NS2S;
			// value[0] += event.values[0] * dT;
			// value[1] += event.values[1] * dT;
			// value[2] += event.values[2] * dT;
			// }
			// timestamp = event.timestamp;
			//			
			// labelX.setText(String.format("X: %+2.5f", value[0]));
			// labelY.setText(String.format("Y: %+2.5f", value[1]));
			// labelZ.setText(String.format("Z: %+2.5f", value[2]));

		}
	}
}